/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NodeReachComponent
extends Component {
    private String m_sourceNode;

    NodeReachComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        this.m_sourceNode = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_SRCNODE);
        Trace.out((String)("==== ParamManager reports source node as " + this.m_sourceNode));
    }

    @Override
    protected boolean checkSetup() {
        boolean succ = true;
        if (null != this.m_sourceNode) {
            Vector<String> succNodes = new Vector<String>();
            Vector<String> failNodes = new Vector<String>();
            Object[] refNodeList = new String[]{this.m_sourceNode};
            ResultSet tmpResultSet = new ResultSet();
            if (!VerificationUtil.isNodeReachable(this.m_sourceNode)) {
                ReportUtil.printError(s_msgBundle.getMessage("4107", true, refNodeList));
                this.getResultSet().addResult(this.getNodeList(), 2);
                return false;
            }
            if (!VerificationUtil.isUserEquivalenceOnNode(this.m_sourceNode, false)) {
                ReportUtil.printError(s_msgBundle.getMessage("4108", true, refNodeList));
                this.getResultSet().addResult(this.getNodeList(), 2);
                return false;
            }
            boolean destLocSucc = VerificationUtil.checkDestLoc((String[])refNodeList, tmpResultSet, succNodes, failNodes, true);
            if (!destLocSucc) {
                Trace.out((String)"SourceNode didn't pass setup checks: checkDestLoc");
                this.getResultSet().addResult(this.getNodeList(), 2);
                return false;
            }
        }
        String[] nodeList = this.getNodeList();
        String[] validNodeList = new String[nodeList.length];
        System.arraycopy(nodeList, 0, validNodeList, 0, validNodeList.length);
        this.setValidNodeList(validNodeList);
        return succ;
    }

    @Override
    public boolean verify() {
        boolean retval = false;
        retval = this.checkSetup();
        if (!retval) {
            return false;
        }
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        TaskNodeConnectivity taskNodeReach = new TaskNodeConnectivity(validNodeArr);
        taskNodeReach.setTaskType(1);
        taskNodeReach.setSourceNode(this.m_sourceNode);
        Trace.out((String)"\n>>>> NodeReachComponent:: Upload taskNodeReach >>>>>\n");
        this.m_resultSet.uploadResultSet(taskNodeReach.getResultSet());
        return retval &= taskNodeReach.perform();
    }

    @Override
    public String getComponentName() {
        return "NODE_REACH";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9961", false);
    }
}

